<?php
session_start();

include("../../../include/config.php");
 
// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["online_ed_pharma_admin_login"]) || $_SESSION["online_ed_pharma_admin_login"] !== true){
    header("location: ../../index.php");
    exit;
}


date_default_timezone_set('Asia/Kolkata');  
$date= date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $_SESSION["online_ed_pharma_admin_page_title"];?> | Admin </title>
    <!-- plugins:css -->
    <link rel="stylesheet" href="../../assets/vendors/iconfonts/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="../../assets/vendors/iconfonts/ionicons/css/ionicons.css">
    <link rel="stylesheet" href="../../assets/vendors/iconfonts/typicons/src/font/typicons.css">
    <link rel="stylesheet" href="../../assets/vendors/iconfonts/flag-icon-css/css/flag-icon.min.css">
    <link rel="stylesheet" href="../../assets/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="../../assets/vendors/css/vendor.bundle.addons.css">
    <!-- endinject -->
    <!-- plugin css for this page -->
    <!-- End plugin css for this page -->
    <!-- inject:css -->
    <link rel="stylesheet" href="../../assets/vendors/iconfonts/font-awesome/css/font-awesome.min.css" />
    <link rel="stylesheet" href="../../assets/css/shared/style.css">
    <!-- endinject -->
    <!-- Layout styles -->
    <link rel="stylesheet" href="../../assets/css/demo_1/style.css">
    <!-- End Layout styles -->
    <link rel="shortcut icon" href="../../assets/images/<?php echo $_SESSION["online_ed_pharma_admin_page_logo"];?>" />

    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css'>

    
    
    <link rel="stylesheet" href="img_up_files/croppie.css" />

  </head>
  <body>
    <div class="container-scroller">
      
      <?php include('../header_inner.php');?>

        <div class="main-panel">
          <div class="content-wrapper">

            <div class="row">         
              
              <div class="col-lg-12 grid-margin stretch-card">
                <div class="card">
                  
                  <div class="card-body table-responsive">
                    <button type="button" class="btn btn-info btn-fw" data-toggle="modal" data-target=".bs-example-modal-new" style="width:10%;float: right;">
                      Add Guard
                  </button>
                    <h4 class="card-title">Guard List</h4>
                    <!--<p class="card-description"> Add class <code>.table-striped</code> </p>-->
                    <table class="table table-striped " >
                      <thead>
                        <tr>
                          <th> RFO </th>
                          <th> Guard ID </th>
                          <th> Name </th>
                          <th> Username </th>            
                          <th> Phone </th>                          
                          <th> Details </th>
                          <th> Delete </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        $sql=mysqli_query($con,"SELECT * FROM guard");
                        while($row=mysqli_fetch_assoc($sql)){
                        ?>
                            <tr>
                                <td><?php echo $row['rfo_name'];?></td>
                                <td><?php echo $row['guard_id'];?></td>
                                <td><?php echo $row['name'];?></td>
                                <td><?php echo $row['username'];?></td>
                                <td><?php echo $row['phone'];?></td>

                                <td ><a href="show_item.php?show=<?php echo $row['id'];?>"><i class="fa fa-eye"></i></a></td>
                                <td><i class="fa fa-trash delete" id="<?php echo $row['id'];?>"></i></td>
                            </tr>
                            
                        <?php
                        }
                        ?>
                       
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>              
              
              
            </div>
          </div>
          <!-- content-wrapper ends -->
          <!-- partial:../../partials/_footer.html -->
          
          <?php include('../footer.php');?>

          <!-- partial -->
        </div>
        <!-- main-panel ends -->
      </div>
      <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->
    <!-- plugins:js -->
    <script src="../../assets/vendors/js/vendor.bundle.base.js"></script>
    <script src="../../assets/vendors/js/vendor.bundle.addons.js"></script>
    <!-- endinject -->
    <!-- Plugin js for this page-->
    <!-- End plugin js for this page-->
    <!-- inject:js -->
    <script src="../../assets/js/shared/off-canvas.js"></script>
    <script src="../../assets/js/shared/misc.js"></script>
    <!-- endinject -->
    <!-- Custom js for this page-->
    <!-- End custom js for this page-->

    <script src="img_up_files/croppie.js"></script>

<!-- Modal Starts-->



<div class="modal fade bs-example-modal-new" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">  
  <div class="modal-dialog">    
    <!-- Modal Content: begins -->
    <div class="modal-content">      
      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="card-title">Create RFO</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>            
      </div>    
      <!-- Modal Body -->  
      <form id="create_event" enctype="multipart/form-data" method="post">
      <div class="modal-body">
        
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-calendar text-white"></i>
              </span>
            </div>
            <select class="form-control" id="rfo_name" name="rfo_name">
              <option selected disabled>Select RFO</option>
              <?php
              $sql=mysqli_query($con,"SELECT * FROM rfo");
              while($row=mysqli_fetch_assoc($sql)){
              ?>
              <option value="<?php echo $row['name'];?>" id="<?php echo $row['rfo_id'];?>"><?php echo $row['name'];?></option>
              <?php
              }
              ?>
              </select>

              <input type="hidden" name="rfo_id" id="rfo_id">

          </div>
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-institution text-white"></i>
              </span>
            </div>
            <input type="text" class="form-control" id="name" name="name" placeholder="Enter Guard Name" aria-label="Username" aria-describedby="colored-addon1" autofocus>
          </div>
        </div>         
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="number" class="form-control" id="phone" name="phone" placeholder="Enter Phone Number" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-user-o text-white"></i>
              </span>
            </div>
            <input type="text" class="form-control" id="username" name="username" placeholder="Enter Username" aria-label="Username" aria-describedby="colored-addon1">
          </div>
          <center><p id='message2'></p></center>
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password" aria-label="Username" aria-describedby="colored-addon1">
          </div>
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="password" class="form-control" id="conf_password" placeholder="Confirm Password" aria-label="Username" aria-describedby="colored-addon1">
          </div>

          <center><h4 class="card-title" id='message1'></h4></center>
        </div>
        
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="number" class="form-control" id="aadhar" name="aadhar" placeholder="Enter Aadhar Number" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="text" class="form-control" id="email" name="email" placeholder="Enter Email" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="text" class="form-control" id="forest_id" name="forest_id" placeholder="Enter Forest ID" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="text" class="form-control" id="lat" name="lat" placeholder="Enter Latitutde" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="text" class="form-control" id="longi" name="longi" placeholder="Enter Longitude" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="number" class="form-control" id="radius" name="radius" placeholder="Enter Radius" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>
        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-lock text-white"></i>
              </span>
            </div>
            <input type="number" class="form-control" id="mpin" name="mpin" placeholder="Enter MPIN" aria-label="Username" aria-describedby="colored-addon1">
          </div>          
        </div>

        <div class="form-group">
          <div class="input-group">
            <div class="input-group-prepend bg-info">
              <span class="input-group-text bg-transparent">
                <i class="fa fa-users text-white"></i>
              </span>
            </div>
            <input name="userImage" type="file" class="inputFile" />
          </div>
        </div>

        <center>
          <button type="submit" class="btn btn-success mr-2" id="saves">Submit</button>
          <button class="btn btn-light"  data-dismiss="modal" aria-label="Close">Cancel</button>
      </center>
      </div> 
      </form>   
      <!-- Modal Footer -->
      
    </div>
    <!-- Modal Content: ends -->    
  </div>  
</div>

<!-- Modal Ends-->


<script>
$(document).ready(function(){
    $("#rfo_name").change(function(){
        var rfo_id = $('#rfo_name option:selected').attr('id');

        $("#rfo_id").val(rfo_id);
    
    });
});
</script>

<script type="text/javascript">
  $('#conf_password').on('keyup', function () {
  if ($('#password').val() == $('#conf_password').val()) {
    $('#message1').html('').css('color', 'green');
  } else 
    $('#message1').html('Password Not Matched').css('color', 'red');
});
</script>

<script src='https://cdn.rawgit.com/t4t5/sweetalert/v0.2.0/lib/sweet-alert.min.js'></script>

<script type="text/javascript">
    $(document).ready(function (e) {
   
      $("#create_event").on('submit',(function(e) {
        e.preventDefault();

  var rfo_name = $('#rfo_name').val();
  var rfo_id = $('#rfo_id').val();
  var name = $('#name').val();
  var phone = $('#phone').val();
  var username = $('#username').val();
  var password = $('#password').val();
  var conf_password = $('#conf_password').val();

  var aadhar = $('#aadhar').val();
  var forest_id = $('#forest_id').val();
  var email = $('#email').val();
  var lat = $('#lat').val();
  var longi = $('#longi').val();
  var radius = $('#radius').val();
  var mpin = $('#mpin').val();
  
  
if(!$('#rfo_name').val() || !$('#name').val() || !$('#phone').val() || !$('#username').val() || !$('#password').val() || !$('#conf_password').val() || !$('#aadhar').val() || !$('#forest_id').val() || !$('#email').val() || !$('#lat').val() || !$('#longi').val() || !$('#radius').val() || !$('#mpin').val()){
   
  if(!$('#rfo_name').val()){
        $("#rfo_name").css("border", "1px solid red");
    
        }
  else{
      $("#rfo_name").css("border", "1px solid #e6e6e6");
  }

  if(!$('#name').val()){
        $("#name").css("border", "1px solid red");
    
        }
  else{
      $("#name").css("border", "1px solid #e6e6e6");
  }
  if(!$('#phone').val()){
        $("#phone").css("border", "1px solid red");
    
        }
  else{
      $("#phone").css("border", "1px solid #e6e6e6");
  }
  if(!$('#username').val()){
        $("#username").css("border", "1px solid red");
    
        }
  else{
      $("#username").css("border", "1px solid #e6e6e6");
  }
  if(!$('#password').val()){
        $("#password").css("border", "1px solid red");
    
        }
  else{
      $("#password").css("border", "1px solid #e6e6e6");
  }
  if(!$('#conf_password').val()){
        $("#conf_password").css("border", "1px solid red");
    
        }
  else{
      $("#conf_password").css("border", "1px solid #e6e6e6");
  }

  if(!$('#aadhar').val()){
        $("#aadhar").css("border", "1px solid red");
    
        }
  else{
      $("#aadhar").css("border", "1px solid #e6e6e6");
  }
  if(!$('#forest_id').val()){
        $("#forest_id").css("border", "1px solid red");
    
        }
  else{
      $("#forest_id").css("border", "1px solid #e6e6e6");
  }
  if(!$('#email').val()){
        $("#email").css("border", "1px solid red");
    
        }
  else{
      $("#email").css("border", "1px solid #e6e6e6");
  }
  if(!$('#lat').val()){
        $("#lat").css("border", "1px solid red");
    
        }
  else{
      $("#lat").css("border", "1px solid #e6e6e6");
  }
  if(!$('#longi').val()){
        $("#longi").css("border", "1px solid red");
    
        }
  else{
      $("#longi").css("border", "1px solid #e6e6e6");
  }
  if(!$('#radius').val()){
        $("#radius").css("border", "1px solid red");
    
        }
  else{
      $("#radius").css("border", "1px solid #e6e6e6");
  }
  if(!$('#mpin').val()){
        $("#mpin").css("border", "1px solid red");
    
        }
  else{
      $("#mpin").css("border", "1px solid #e6e6e6");
  }

  if(!$('#image').val()){
        
        return false;
    
        }
 

  

        } 

      else{ 

        $.ajax({
          url: "query/insert_guard.php",
          type: "POST",
          data:  new FormData(this),
          contentType: false,
              cache: false,
          processData: false,

          beforeSend: function(){
           $(".loader").show();
           },
           complete: function(){
             $(".loader").hide();
           },
           
          success: function(data)
            {
              
              swal({
                title: "Done !",
                text: "Guard Created Successfully",
                type:'success',
                showCancelButton: false,
                confirmButtonColor: '#7db432',
                confirmButtonText: 'OK',
                closeOnConfirm: false,
                //closeOnCancel: false
               
              },
              function(){
                window.location.reload();
              });

            },
            error: function(data)
            {
                
              alert('Something Went Wrong');
            }
         });
     }

   }));
    });

</script>








<div id="uploadimageModal" class="modal" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Upload & Crop Image</h4>
          </div>
          <div class="modal-body">
            <div class="row" >
            <div class="col-md-8 text-center" >
              <div id="image_demo" style="width:250px; margin-top:30px;"></div>
            </div>
            
        </div>
        <div class="col-md-4" style="padding-top:30px;">
              
              <button class="btn btn-success crop_image">Crop & Upload Image</button>
          </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          </div>
      </div>
    </div>
</div>

<script>  
$(document).ready(function(){

  $image_crop = $('#image_demo').croppie({
    enableExif: true,
    viewport: {
      width:350,
      height:320,
      type:'square' //circle
    },
    boundary:{
      width:400,
      height:400
    }
  });

  $('#upload_image').on('change', function(){
    var reader = new FileReader();
    reader.onload = function (event) {
      $image_crop.croppie('bind', {
        url: event.target.result
      }).then(function(){
        console.log('jQuery bind complete');
      });
    }
    reader.readAsDataURL(this.files[0]);
    $('#uploadimageModal').modal('show');
  });

  $('.crop_image').click(function(event){
    $image_crop.croppie('result', {
      type: 'canvas',
      size: 'viewport'
    }).then(function(response){
      $.ajax({
        url:"img_up_files/upload.php",
        type: "POST",
        data:{"image": response},
        success:function(data)
        {
          $('#uploadimageModal').modal('hide');
          $('#uploaded_image').html(data);
        }
      });
    })
  });

});  
</script>




<script >
$(document).ready(function(){
   $(document).on('click', '.delete', function(){
    var item_id = $(this).attr("id");
    

  swal({
    title: "Are you sure?",
    text: "This Guard Will Be Deleted.",
    type: "warning",
    showCancelButton: true,
    confirmButtonColor: '#fc544b',
    confirmButtonText: 'Yes, delete it!',
    closeOnConfirm: false,
    //closeOnCancel: false
  },
  function(){
    
    swal("Deleted!", "Guard has been deleted!", "success");
    
        $.ajax({
          url:"query/delete_guard.php",
          method:"POST",
          data:{item_id:item_id, },
          success:function()
          {
          
            window.location.reload();
          }
        })

  });
});

});


</script>
  </body>
</html>